function weightSimilarityComp(obj)
%WEIGHTSIMILARITY Summary of this function goes here
%   Detailed explanation goes here


if ~isempty(obj.groups)
    
    outMat1 = combineCells(obj.adjMat1,{},obj.groups);
    outMat2 = combineCells(obj.adjMat2,{},obj.groups);
    inMat1 = combineCells(obj.adjMat1,obj.groups,{});
    inMat2 = combineCells(obj.adjMat2,obj.groups,{});
    
    [mat rowLabels1 colLabelsOut1] = getMatrix(outMat1);
    [mat rowLabels2 colLabelsOut2] = getMatrix(outMat2);
    [mat rowLabelsIn1 colLabels1] = getMatrix(inMat1);
    [mat rowLabelsIn2 colLabels2] = getMatrix(inMat2);
    
    % Use colLabelsOut and rowLabelsIn to ensure that the order is the same
    % in all the matrices
    [tmp A1out] = getSubMatrix(outMat1,obj.SrowLabels,obj.combineMethod(colLabelsOut1,colLabelsOut2));
    [tmp A2out] = getSubMatrix(outMat2,obj.ScolumnLabels,obj.combineMethod(colLabelsOut1,colLabelsOut2));
    [tmp A1in] = getSubMatrix(inMat1,obj.combineMethod(rowLabelsIn1,rowLabelsIn2),obj.SrowLabels);
    [tmp A2in] = getSubMatrix(inMat2,obj.combineMethod(rowLabelsIn1,rowLabelsIn2),obj.ScolumnLabels);
    
    
    switch obj.direction
        case 'outgoing'
            num = makeMat(A1out,A2out);
        case 'incoming'
            num = makeMat(A1in',A2in');
        case 'both'
            outSim = makeMat(A1out,A2out);
            inSim = makeMat(A1in',A2in');
            num = outSim + inSim;
    end
else
    [tmp A1out] = getSubMatrix(obj.adjMat1,obj.SrowLabels,obj.combineMethod(obj.SrowLabels,obj.SColumnLabels));
    [tmp A2out] = getSubMatrix(obj.adjMat2,obj.ScolumnLabels,obj.combineMethod(obj.SrowLabels,obj.SColumnLabels));    
    [tmp A1in] = getSubMatrix(obj.adjMat1,obj.combineMethod(obj.SrowLabels,obj.SColumnLabels),obj.SrowLabels);
    [tmp A2out] = getSubMatrix(obj.adjMat2,obj.combineMethod(obj.SrowLabels,obj.SColumnLabels),obj.ScolumnLabels);    
    
    switch obj.direction
        case 'outgoing'
            num = makeMat(A1out,A2out);
        case 'incoming'
            num = makeMat(A1in',A2in');
        case 'both'
            num = makeMat(A1out,A2out) + makeMat(A1in',A2in');            
    end
end



% Various ways of normalizing
% denom = (diag(num) * diag(num)').^(1/2);
% N = size(num,1);
% denom = repmat(diag(num),[1 N]) + repmat(diag(num)',[N 1]);
% denom = denom./2;

denom = 1;
obj.S = num./denom;


    function S = makeMat(adjMat1,adjMat2)   %Form the similarity matrix using row comparisons
        S = zeros(size(adjMat1,1),size(adjMat2,1));
        
        for i = 1:size(adjMat1,1)
            for j = 1:size(adjMat2,1)
                S(i,j) = sum(weightSim(adjMat1(i,:),adjMat2(j,:)));
                
            end
        end

        
    end
end

